import com.dkt.graphics.canvas.Canvas;
import com.dkt.graphics.canvas.CanvasFrame;
import com.dkt.graphics.extras.formula.ParametricCalculable;
import com.dkt.graphics.extras.formula.ParametricCalculableTimer;
import com.dkt.graphics.utils.Utils;
import java.awt.Color;

public class Parametric {
    public static void main(String[] args) {
        //////////////////////////////////////////////////////////
        //The name that appears in the window
        String title = "Parametric example";
        //We need to create a new frame
        CanvasFrame frame = new CanvasFrame(title);
        //And make it visible
        frame.setVisible(true);
        //Set a size in pixels (whichever you want)
        frame.setSize(550/*width*/, 550/*height*/);
        //Extract a reference to the canvas from the frame
        final Canvas canvas = frame.getCanvas();
        //Tell the canvas to center the origin of coordinates,
        //which by default is located in the upper left corner
        canvas.setCenterOrigin(true);
        //Tell the canvas to invert the Y axis, this way we will
        //consider all positive Y increments from the origin of
        //coordinates to the title bar
        canvas.setInvertYAxis(true);
        //////////////////////////////////////////////////////////
        canvas.setAutoRepaint(true);
        canvas.setRepaintDelay(35);

        final double a = 1;
        final double b = 60;
        final double c = 1;
        final double d = 1;
        final double e = 60;
        final double i = 1;
        final double j = 2;

        ParametricCalculable eq = new ParametricCalculable() {
            @Override
            public double x(double t) {
                return i * Math.cos(a * t) - Math.cos(b * t) * Math.sin(c * t);
            }

            @Override
            public double y(double t) {
                return j * Math.sin(d * t) - Math.sin(e * t);
            }
        };

        eq.setScaleX(80);
        eq.setScaleY(80);
        eq.startPoint(0);
        eq.endPoint(2 * Math.PI);
        eq.step(0.000001);

        ParametricCalculableTimer timer = new ParametricCalculableTimer(eq);
        timer.setPaint(Utils.getColorWithAlpha(Color.BLUE, 64));
        canvas.add(timer);

        timer.start();
    }
}
