import com.dkt.graphics.canvas.Canvas;
import com.dkt.graphics.canvas.CanvasFrame;
import com.dkt.graphics.exceptions.DomainException;
import com.dkt.graphics.extras.GAxis;
import com.dkt.graphics.extras.GFormula;
import com.dkt.graphics.extras.formula.Calculable;

public class Plotting {
    public static void main(String[] args) {
        //////////////////////////////////////////////////////////
        //The name that appears in the window
        String title = "Plotting sin(x)";
        //We need to create a new frame
        CanvasFrame frame = new CanvasFrame(title);
        //And make it visible
        frame.setVisible(true);
        //Set a size in pixels (whichever you want)
        frame.setSize(550/*width*/, 550/*height*/);
        //Extract a reference to the canvas from the frame
        Canvas canvas = frame.getCanvas();
        //Tell the canvas to center the origin of coordinates,
        //which by default is located in the upper left corner
        canvas.setCenterOrigin(true);
        //Tell the canvas to invert the Y axis, this way we will
        //consider all positive Y increments from the origin of
        //coordinates to the title bar
        canvas.setInvertYAxis(true);
        //////////////////////////////////////////////////////////
        Calculable calculable = new Calculable() {
            @Override
            public double f(double x) throws DomainException {
                return Math.sin(x);
            }
        };
        calculable.setScaleX(40);
        calculable.setScaleY(60);
        GFormula formula = new GFormula(calculable);
        // Paints should be set before calling the calculate methods
        // I use -π to π so the function is centered
        formula.calculatePath(-Math.PI, Math.PI, 0.01);
        canvas.add(formula);
        GAxis axis = new GAxis(-300, 300, -300, 300);
        axis.drawLinesH(true);
        axis.drawLinesV(true);
        canvas.addFixed(axis);
        //In order for the elements to be drawn in the canvas, is
        //necessary to call 'canvas.repaint()' after we add the
        //elements to it.
        //PS: There's an autorepaint feature (disabled by default).
        canvas.repaint();
    }
}
