import com.dkt.graphics.canvas.Canvas;
import com.dkt.graphics.canvas.CanvasFrame;
import com.dkt.graphics.exceptions.DomainException;
import com.dkt.graphics.extras.GAxis;
import com.dkt.graphics.extras.GFormula;
import com.dkt.graphics.extras.formula.Calculable;
import com.dkt.graphics.utils.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

public class Plotting2 {
    public static void main(String[] args) {
        //////////////////////////////////////////////////////////
        //The name that appears in the window
        String title = "Plotting sin(x)";
        //We need to create a new frame
        CanvasFrame frame = new CanvasFrame(title);
        //And make it visible
        frame.setVisible(true);
        //Set a size in pixels (whichever you want)
        frame.setSize(550/*width*/, 550/*height*/);
        //Extract a reference to the canvas from the frame
        Canvas canvas = frame.getCanvas();
        //Tell the canvas to center the origin of coordinates,
        //which by default is located in the upper left corner
        canvas.setCenterOrigin(true);
        //Tell the canvas to invert the Y axis, this way we will
        //consider all positive Y increments from the origin of
        //coordinates to the title bar
        canvas.setInvertYAxis(true);
        //////////////////////////////////////////////////////////
        
        Calculable calculable = new Calculable() {
            @Override
            public double f(double x) throws DomainException {
                return Math.sin(x);
            }
        };
        calculable.setScaleX(40);
        calculable.setScaleY(60);

        GFormula formula = new GFormula(calculable);
        formula.setPaint(Color.ORANGE); // <--
        formula.calculatePath(-Math.PI, Math.PI, 0.01);

        // This variables aren't really necessary, but the code
        // needs to be short for the wiki.
        final int cap  = BasicStroke.CAP_ROUND;
        final int join = BasicStroke.JOIN_ROUND;
        final float[] dash = new float[] {5, 5};
        Stroke stroke = new BasicStroke(1, cap, join, 0, dash, 0);

        // This creates a new color with 32 as the alpha value
        Color background = Utils.getColorWithAlpha(Color.GREEN, 32);
        GFormula area = new GFormula(calculable);
        area.setPaint(Color.GREEN);
        area.setAreaPaint(background);
        area.setStroke(stroke);
        // Calculate the area in the interval
        area.calculateArea(1, 2, 0.01);

        GAxis axis = new GAxis(-300, 300, -300, 300);
        axis.drawLinesH(true);
        axis.drawLinesV(true);

        canvas.add(area);
        canvas.add(axis);
        canvas.add(formula);
        
        //In order for the elements to be drawn in the canvas, is
        //necessary to call 'canvas.repaint()' after we add the
        //elements to it.
        //PS: There's an autorepaint feature (disabled by default).
        canvas.repaint();
    }
}
